import { Selector } from 'testcafe';

fixture('Syracuse')
    .page(`http://${process.env.DOMAIN ?? "localhost"}:5173`)
    .beforeEach(async t => {
        const suiteSelection = Selector('#suite');
        const cityOption = suiteSelection.find('option');
        const inputNumber = Selector('#number');
        const inputSubscript = Selector('#subscript')
        await t
            .click(suiteSelection)
            .click(cityOption.withText("Syracuse"))
        t.ctx = {
            inputNumber,
            inputSubscript
        }
    });

test('Syracuse(1, 1)', async t => {
    await t.typeText(t.ctx.inputNumber, '1', {replace: true});
    await t.typeText(t.ctx.inputSubscript, '1', {replace: true});
    await t.expect(Selector('#resultat').innerText).eql('4');
});

test('Syracuse(2, 1)', async t => {
    await t.typeText(t.ctx.inputNumber, '2', {replace: true});
    await t.typeText(t.ctx.inputSubscript, '1', {replace: true});
    await t.expect(Selector('#resultat').innerText).eql('7');
});

test('Syracuse(2, 2)', async t => {
    await t.typeText(t.ctx.inputNumber, '2', {replace: true});
    await t.typeText(t.ctx.inputSubscript, '2', {replace: true});
    await t.expect(Selector('#resultat').innerText).eql('3.5');
});

test('Syracuse(3, 1)', async t => {
    await t.typeText(t.ctx.inputNumber, '3', {replace: true});
    await t.typeText(t.ctx.inputSubscript, '1', {replace: true});
    await t.expect(Selector('#resultat').innerText).eql('10');
});

test('Syracuse(3, 2)', async t => {
    await t.typeText(t.ctx.inputNumber, '3', {replace: true});
    await t.typeText(t.ctx.inputSubscript, '2', {replace: true});
    await t.expect(Selector('#resultat').innerText).eql('5');
});

test('Syracuse(12, 1)', async t => {
    await t.typeText(t.ctx.inputNumber, '12', {replace: true});
    await t.typeText(t.ctx.inputSubscript, '1', {replace: true});
    await t.expect(Selector('#resultat').innerText).eql('37');
});