import { Selector } from 'testcafe';

fixture('Padovan')
    .page(`http://${process.env.DOMAIN ?? "localhost"}:5173`)
    .beforeEach(async t => {
        const suiteSelection = Selector('#suite');
        const cityOption = suiteSelection.find('option');
        const inputNumber = Selector('#number');
        await t
            .click(suiteSelection)
            .click(cityOption.withText("Padovan"));
        t.ctx = {
            inputNumber
        }
    });

test('Padovan(1)', async t => {
    await t.typeText(t.ctx.inputNumber, '1', {replace: true});
    await t.expect(Selector('#resultat').innerText).eql('1');
});

test('Padovan(2)', async t => {
    await t.typeText(t.ctx.inputNumber, '2', {replace: true});
    await t.expect(Selector('#resultat').innerText).eql('1');
});

test('Padovan(3)', async t => {
    await t.typeText(t.ctx.inputNumber, '3', {replace: true});
    await t.expect(Selector('#resultat').innerText).eql('2');
});

test('Padovan(4)', async t => {
    await t.typeText(t.ctx.inputNumber, '4', {replace: true});
    await t.expect(Selector('#resultat').innerText).eql('2');
});

test('Padovan(12)', async t => {
    await t.typeText(t.ctx.inputNumber, '12', {replace: true});
    await t.expect(Selector('#resultat').innerText).eql('21');
});