import { Selector } from 'testcafe';

fixture('Fibonacci')
    .page(`http://${process.env.DOMAIN ?? "localhost"}:5173`)
    .beforeEach(async t => {
        const suiteSelection = Selector('#suite');
        const cityOption = suiteSelection.find('option');
        const inputNumber = Selector('#number');
        await t
            .click(suiteSelection)
            .click(cityOption.withText("Fibonacci"));
        t.ctx = {
            inputNumber
        }
    });

test('Fibonacci(1)', async t => {
    await t.typeText(t.ctx.inputNumber, '1', {replace: true});
    await t.expect(Selector('#resultat').innerText).eql('1');
});

test('Fibonacci(2)', async t => {
    await t.typeText(t.ctx.inputNumber, '2', {replace: true});
    await t.expect(Selector('#resultat').innerText).eql('1');
});

test('Fibonacci(3)', async t => {
    await t.typeText(t.ctx.inputNumber, '3', {replace: true});
    await t.expect(Selector('#resultat').innerText).eql('2');
});

test('Fibonacci(4)', async t => {
    await t.typeText(t.ctx.inputNumber, '4', {replace: true});
    await t.expect(Selector('#resultat').innerText).eql('3');
});

test('Fibonacci(12)', async t => {
    await t.typeText(t.ctx.inputNumber, '12', {replace: true});
    await t.expect(Selector('#resultat').innerText).eql('144');
});