import './style.css'
import {useState} from 'react';
import {Fibonacci} from '../component/Fibonacci.jsx';
import {Padovan} from '../component/Padovan.jsx';
import {Syracuse} from '../component/Syracuse.jsx';

export function Selection(){
    const [choice, setChoice] = useState();
    const [value, setValue] = useState(1);
    const [subscript, setSubscript] = useState(1);

    let Content;
    switch (choice){
        case 'fibonacci':
            Content = <Fibonacci number={value}/>
            break;
        case 'padovan':
            Content = <Padovan number={value}/>
            break;
        case 'syracuse':
            Content = <Syracuse number={value} subscript={subscript}/>
            break;
        default:
            Content = null;
    }

    function handleChoice(event){
        setChoice(event.target.value)
    }

    return(
        <div className={"splitScreen"}>
            <div className={"item"}>
                <label>Choisissez une suite mathématique:</label>
                <select onChange={handleChoice} id={"suite"}>
                    <option value="fibonacci">Fibonacci</option>
                    <option value="syracuse">Syracuse</option>
                    <option value="padovan">Padovan</option>
                    <option value="aucune" selected>Aucune</option>
                </select>
                <div>
                    <label>Choisissez un nombre:</label>
                    <input
                        id={"number"}
                        type={'number'}
                        min={1}
                        onChange={event => setValue(parseInt(event.target.value))}
                        defaultValue={value}
                    />
                </div>
                {choice === "syracuse" && (
                    <div>
                        <label>Choisissez un subscript:</label>
                        <input
                            id={"subscript"}
                            type={'number'}
                            min={1}
                            onChange={event => setSubscript(parseInt(event.target.value))}
                            defaultValue={subscript}
                        />
                    </div>
                )}
            </div>
            <div className={"item"}>
                {Content}
            </div>
        </div>
    )


}