import {useState, useEffect} from "react"
export function useAPICall(cb, params){
    const [pending, setPending] = useState(true);
    const [status, setStatus] = useState({});


    useEffect(() => {
        cb(...params).then(val => {
            setStatus({
                err: false,
                data: val.resultat
            });
        }).catch(err => {
            setStatus({
                err: true,
                data: err
            });
            console.log(err);
        }).finally(_ => {
            setPending(false);
        });
    }, [...params]);

    return [pending, status];
}