import {describe, test, expect} from 'vitest';
import {syracuse} from "../src/syracuse";

describe("Syracuse sequence for 15", () => {

    test("Error if negatif argument", () => {
       expect(() => syracuse(0, -1)).toThrowError("Only positif arguments !");
       expect(() => syracuse(-1, 0)).toThrowError("Only positif arguments !");
    });

    test("should be 15", () => {
        expect(syracuse(15, 0)).toBe(15);
    });

    test("should be 46", () => {
        expect(syracuse(15, 1)).toBe(46);
    });

    test("should be 23", () => {
        expect(syracuse(15, 2)).toBe(23);
    });

    test("should be 53", () => {
        expect(syracuse(15, 6)).toBe(53);
    });

})

describe("Syracuse sequence for 7", () => {

    test("should be 7", () => {
        expect(syracuse(7, 0)).toBe(7);
    });

    test("should be 22", () => {
        expect(syracuse(7, 1)).toBe(22);
    });

    test("should be 11", () => {
        expect(syracuse(7, 2)).toBe(11);
    });

    test("should be 52", () => {
        expect(syracuse(7, 5)).toBe(52);
    });

})