module.exports = {
    root: true,
    env: {
        es6: true,
        node: true
    },
    'extends': [
        'eslint:recommended'
    ],
    parserOptions: {
        "ecmaVersion": 2021,
        "sourceType": "module"
    },
    rules: {
        'array-bracket-spacing': 1,
        'arrow-spacing': 1,
        'brace-style': 1,
        'comma-dangle': 1,
        'comma-spacing': 1,
        'eol-last': 1,
        'implicit-arrow-linebreak': 1,
        'indent': [1, 4],
        'key-spacing': 1,
        'keyword-spacing': 1,
        'no-multi-spaces': 1,
        'no-multiple-empty-lines': [1, { 'max': 1 }],
        'no-whitespace-before-property': 1,
        'no-trailing-spaces': 1,
        'no-var': 2,
        'nonblock-statement-body-position': 1,
        'object-curly-spacing': [1, 'always'],
        'prefer-const': 2,
        'quotes': [1, 'single'],
        'semi': [1, 'always'],
        'space-before-blocks': 1,
        'space-before-function-paren': 1,
        'space-in-parens': 1,
        'space-infix-ops': 1,
        'space-unary-ops': 1,
        'spaced-comment': 1,
        'switch-colon-spacing': 1
    }
}
