let os = require("os"); // Import any Node.js module you want.

module.exports = { // Settings go inside the module.exports statement.
    src: "tests/", // Tests
    browsers: ["chromium:headless", "firefox:headless"], // Browsers
    skipJsErrors: true, // Ignores JavaScript errors
    hostname: os.hostname(), // Node.js dynamically calculates the value of this parameter.
    concurrency: 2,
    screenshots: {
        path: "tests/screenshots/",
        takeOnFails: true,
        thumbnails: false
    }
}