import {Router} from "express";

import {fibonacci} from "../src/fibonacci.js";
import {padovan} from "../src/padovan.js";
import {syracuse} from "../src/syracuse.js";

const router = Router();

router.get("/fibonacci", ((req, res) => {
    const number = parseInt(req.query.number);
    try{
        const result = fibonacci(number);
        res.send({resultat: result});
    } catch (e) {
        res.sendStatus(400)
    }
}));

router.get("/padovan", ((req, res) => {
    const number = parseInt(req.query.number)
    try{
        const result = padovan(number);
        res.send({resultat: result});
    } catch (e) {
        res.sendStatus(400);
    }
}));

router.get('/syracuse', ((req, res) => {
    const number = parseInt(req.query.number);
    const subscript = parseInt(req.query.subscript);
    try{
        const result = syracuse(number, subscript);
        res.send({resultat: result});
    } catch (e) {
        res.sendStatus(400);
    }
}));

export default router;

